#include <stdio.h>
#include <stdlib.h>
#include <math.h>

//
inline double f(double x)
{
    // Integrande
    return sqrt(1-x*x);
}
int main(int argc, char** argv)
{
    if (argc < 2)
    {
        fprintf(stderr, "Please give the number of steps for integration");
        return 1;
    }
    unsigned int steps = atoi(argv[1]);
    float pi = 0.0;
    unsigned int i = 0;
    float dx = 1./steps;

//
    for (i=0; i<steps; ++i)
    {
        pi += f(i*dx)+f((i+1)*dx);
    }
    printf("pi is %25.20f with %d steps\n", 2*pi/steps, steps);
}
