#!/usr/bin/env bash
if [ ! -d movie ]
then
    mkdir movie
else
    rm -rf movie/*
fi
mv *.gray movie
cd movie

X=$(( $1 + 2 ))
Y=$(( $2 + 2 ))
for file in *.gray
do
    name=$(basename $file .gray)
    convert -depth 8 -size ${X}x${Y} $file ${name}.png
done

convert -delay 1x24 -loop 0 *.png movie.gif
