MODULE pixels
  USE OPENACC
  IMPLICIT NONE

CONTAINS

  SUBROUTINE fill(pic,rows,cols)

    INTEGER(kind=1),DIMENSION(0:),INTENT(OUT) :: pic
    INTEGER,INTENT(IN)                        :: rows,cols
    INTEGER                                   :: i,j

    DO i=0, rows-1
       DO j=0, 3*cols-1
          pic(i*3*cols+j) = (MOD(i*j,128))
       END DO
    END DO

  END SUBROUTINE fill

  INTEGER(kind=1) FUNCTION weight(pic, x, y, l, cols)

    INTEGER(kind=1),DIMENSION(0:),INTENT(IN) :: pic
    INTEGER,INTENT(IN)                       :: x,y,l,cols
    INTEGER(kind=1),DIMENSION(0:4,0:4)       :: coefs
    INTEGER                                  :: i,j,pix

    coefs(0,:)= (/ 1, 4, 6, 4, 1 /)
    coefs(1,:)= (/ 4, 16, 24, 16, 4 /)
    coefs(2,:)= (/ 6, 24, 36, 24, 6 /)
    coefs(3,:)= (/ 4, 16, 24, 16, 4 /)
    coefs(4,:)= (/ 1, 4, 6, 4, 1 /)

    pix = 0

    DO i=0,4
       DO j=0,4
          pix = (pic((x+i-2)*3*cols+y*3+l-2+j))*(coefs(i,j)) + pix
       END DO
    END DO

    weight=(pix/256)

  END FUNCTION weight

  SUBROUTINE blur(pic, blurred, rows, cols)

    INTEGER(kind=1),DIMENSION(0:),INTENT(IN)  :: pic
    INTEGER(kind=1),DIMENSION(0:),INTENT(OUT) :: blurred
    INTEGER,INTENT(IN)                        :: rows,cols
    INTEGER                                   :: i,j,l

    !...
    DO i=2,rows-3
       DO j=2,cols-3
          DO l=0,2
             blurred(i*3*cols+j*3+l)=weight(pic, i, j, l, cols)
          END DO
       END DO
    END DO

  END SUBROUTINE blur

  SUBROUTINE out_pic(pic, name)

    INTEGER(kind=1),DIMENSION(0:),INTENT(IN) :: pic
    CHARACTER(len=*),INTENT(IN)              :: name  
    INTEGER                                  :: my_unit

    OPEN(NEWUNIT=my_unit, FILE=name, ACCESS="stream", FORM="unformatted")
    WRITE(my_unit,POS=1) pic 
    CLOSE(my_unit)

  END SUBROUTINE out_pic

  INTEGER FUNCTION checksum(pic, rows, cols)

    ! Erreur openacc si INTEGER(kind=1),DIMENSION(0:),INTENT(IN) :: pic
    INTEGER(kind=1),DIMENSION(0:),INTENT(INOUT) :: pic
    INTEGER,INTENT(IN)                          :: rows,cols
    INTEGER                                     :: sum1,sum2,val,i,j,l

    sum1=0
    sum2=0
    val=42424242

    DO i=2, rows-3
       sum2=0
       DO j=2,cols-3
          DO l=0,2
             sum2 = pic(i*3*cols+j*3+l) + sum2
          END DO
       END DO
       sum1 = MOD(sum2,128) + sum1
    END DO
    PRINT *,"sum1 = ",sum1

    checksum = ISHFT(IEOR(sum1,val),8)

  END FUNCTION checksum

END MODULE pixels


PROGRAM blur_pix
  USE PIXELS
  IMPLICIT NONE

  INTEGER                                   :: rows,cols,i,long,j,check
  INTEGER(kind=1),DIMENSION(:), ALLOCATABLE :: pic,blurred_pic
  CHARACTER(len=:), ALLOCATABLE             :: arg
  INTEGER,DIMENSION(2)                      :: n

  DO i=1, COMMAND_ARGUMENT_COUNT()
     CALL GET_COMMAND_ARGUMENT(NUMBER=i, LENGTH=long)
     ALLOCATE(CHARACTER(len=long) :: arg)
     CALL GET_COMMAND_ARGUMENT(NUMBER=i, VALUE=arg)
     READ(arg,'(i10)') n(i)
     DEALLOCATE(arg)
  END DO

  rows=n(1)
  cols=n(2)

  ALLOCATE(pic(0:rows*3*cols-1),blurred_pic(0:rows*3*cols-1))
  CALL fill(pic,rows,cols)

  CALL blur(pic, blurred_pic, rows, cols)

  check = checksum(blurred_pic, rows, cols)

  IF (rows*cols <= 16000000) THEN
     CALL out_pic(pic, "pic")
     CALL out_pic(blurred_pic, "blurred")
  END IF

  PRINT *,"Checksum ",check

  DEALLOCATE(pic,blurred_pic)

END PROGRAM blur_pix
