PROGRAM CALCUL_PI
  USE ISO_FORTRAN_ENV, ONLY : INPUT_UNIT, REAL64
  IMPLICIT NONE
  INTEGER           :: i,nb_steps
  REAL(kind=real64) :: pi,dx

  PRINT *,"Enter the number of steps for integration"
  READ(input_unit,*) nb_steps
  
  pi = 0._real64
  dx = 1._real64/REAL(nb_steps,real64)
 
  !$acc parallel loop gang worker vector reduction(+:pi)
  DO i=0,nb_steps-1
     pi =  SQRT(1.-(i*dx)**2) + SQRT(1.-((i+1)*dx)**2) + pi
  END DO

  PRINT *," pi is ", 2._real64*pi*dx," with ",nb_steps," steps"
  
END PROGRAM CALCUL_PI
