#!/bin/bash
#SBATCH --job-name=petscDMDA       # nom du job
#SBATCH --nodes=1                  # Nombre de noeud
#SBATCH --ntasks=4                 # Nombre total de processus MPI
##SBATCH --gres=gpu:4              # Nombre de GPU à réserver par noeud, à décommenter sur partition GPU
#SBATCH --hint=nomultithread       # 1 processus MPI par coeur physique (pas d'hyperthreading)
#SBATCH --time=00:10:00            # Temps d’exécution maximum demande (HH:MM:SS)
#SBATCH --output=petscDMDA%j.out   # Nom du fichier de sortie
#SBATCH --error=petscDMDA%j.out    # Nom du fichier d'erreur (ici commun avec la sortie)

# on se place dans le répertoire de soumission
cd ${SLURM_SUBMIT_DIR}

# nettoyage des modules charges en interactif et herites par defaut
module purge

# chargement des modules
source ../../../petsc.sh

# Pour éviter des problèmes potentiels avec le GPU Direct.
export PSM2_GPUDIRECT=0

# echo des commandes lancées
set -x

#extra_args="-log_view"
#extra_args="-dm_mat_type aij -dm_vec_type mpi"
#extra_args="-dm_mat_type aijcusparse -dm_vec_type cuda"

size=1000

# exécution du code
time srun ./dmda.exe $extra_args -da_grid_x $size -da_grid_y $size -ksp_type cg -pc_type hypre
