#!/bin/bash
#SBATCH --job-name=petscKSP        # nom du job
#SBATCH --nodes=1                  # Nombre de noeuds
#SBATCH --ntasks=4                 # Nombre total de processus MPI
##SBATCH --gres=gpu:4              # nombre de GPU à réserver par nœud, à décommenter sur partition GPU
#SBATCH --hint=nomultithread       # 1 processus MPI par coeur physique (pas d'hyperthreading)
#SBATCH --time=00:10:00            # Temps d’exécution maximum demande (HH:MM:SS)
#SBATCH --output=petscKSP%j.out    # Nom du fichier de sortie
#SBATCH --error=petscKSP%j.out     # Nom du fichier d'erreur (ici commun avec la sortie)

# on se place dans le répertoire de soumission
cd ${SLURM_SUBMIT_DIR}

# nettoyage des modules charges en interactif et herites par defaut
module purge

# chargement des modules
source ../../../petsc.sh

# Pour éviter des problèmes potentiels avec le GPU Direct.
export PSM2_GPUDIRECT=0

# echo des commandes lancées
set -x

#extra_args="-log_view"
#extra_args="-mat_type mpiaij -vec_type mpi"
#extra_args="-mat_type aijcusparse -vec_type cuda"

size=1000

# exécution du code
time srun ./solver.exe $extra_args -size $size
echo "---------------------------------------------------------------------------------------"
time srun ./solver.exe $extra_args -ksp_type cg -size $size
echo "---------------------------------------------------------------------------------------"
time srun ./solver.exe $extra_args -ksp_type cg -pc_type jacobi -size $size
echo "---------------------------------------------------------------------------------------"
time srun ./solver.exe $extra_args -ksp_type cg -pc_type hypre -size $size
echo "---------------------------------------------------------------------------------------"
time srun ./solver.exe $extra_args -ksp_type preonly -pc_type lu -pc_factor_mat_solver_type mumps -size $size
echo "---------------------------------------------------------------------------------------"
time srun ./solver.exe $extra_args -ksp_type cg -pc_type jacobi -ksp_norm_type unpreconditioned -size $size
echo "---------------------------------------------------------------------------------------"
time srun ./solver.exe $extra_args -ksp_type cg -pc_type hypre -ksp_norm_type unpreconditioned -size $size
