#!/bin/bash
#SBATCH --job-name=petscKSP        # nom du job
#SBATCH --nodes=1                  # Nombre de noeud
#SBATCH --ntasks=4                 # Nombre total de processus MPI
##SBATCH --gres=gpu:4              # Nombre de GPU à réserver par noeud, à décommenter sur partition GPU
#SBATCH --hint=nomultithread       # 1 processus MPI par coeur physique (pas d'hyperthreading)
#SBATCH --time=00:10:00            # Temps d’exécution maximum demande (HH:MM:SS)
#SBATCH --output=petscKSP%j.out    # Nom du fichier de sortie
#SBATCH --error=petscKSP%j.out     # Nom du fichier d'erreur (ici commun avec la sortie)

# on se place dans le répertoire de soumission
cd ${SLURM_SUBMIT_DIR}

# nettoyage des modules charges en interactif et herites par defaut
module purge

# chargement des modules
#module load intel-all/19.0.4
source ../../petsc.sh

# echo des commandes lancées
set -x

# exécution du code
time srun ./solver.exe
